<?php
include 'includes/db.php'; // Adjust path if needed

$today = date('Y-m-d');
$due_date = date('Y-m-d', strtotime('+7 days'));

// Step 1: Expire members whose expiry is in the past
$expire = "UPDATE members 
           SET payment_status = 'Expired' 
           WHERE expiry_date < '$today'";
mysqli_query($conn, $expire);

// Step 2: Mark members as Due if expiry is within the next 7 days
$due = "UPDATE members 
        SET payment_status = 'Due' 
        WHERE expiry_date >= '$today' 
          AND expiry_date <= '$due_date'";
mysqli_query($conn, $due);

// Step 3: Mark members as OK if expiry is more than 7 days in the future
$ok = "UPDATE members 
       SET payment_status = 'OK' 
       WHERE expiry_date > '$due_date'";
mysqli_query($conn, $ok);

echo "Status auto-update complete.";
?>
